﻿/*
VERSION:		1.2

DESCRIPTION:
	Returns an array of sprite data, based on a text-list of flag conditions.
	This is typically used by level editors.

POSSIBLE DISPLAY VALUES:
	myFlag
	!myFlag
	myFlag = undefined		(same as not including it)
	myFlag = true
	myFlag != 10
	myFlag = ""
	myFlag = "merf"
	myFlag = 0
	myFlag > -1
	myFlag < -77
	myFlag >= 4
	myFlag <= 17
	myObj.anotherObject.myFlag = 973
	
POSSIBLE FLAG VALUES:
	myFlag
	!myFlag
	myFlag = undefined		(not whether it's false, whether it's nonexistant)
	myFlag = true
	myFlag != 10
	myFlag = ""
	myFlag = "merf"
	myFlag = 0
	myFlag > -1
	myFlag < -77
	myFlag >= 4
	myFlag <= 17
	myObj.anotherObject.myFlag = 973
*/
getFlaggedSprites = function( sprites, displayFlags )
{
	var getFlagParts = function( flag )
	{// convert "myFlag" to "myFlag != undefined"		"!myFlag" to "myFlag = undefined"		"myFlag>2" to "myFlag > 2"
		var parts_array = [];
		
		// remove space from beginning of flag
		var firstChar = flag.charAt(0);
		while(firstChar==" "){
			flag = flag.substr(1);		// chop off first character
			firstChar = flag.charAt(0);
		}// while:  space exists at the beginning
		
		
		// remove space from end of flag
		var lastChar = flag.charAt( flag.length-1 );
		while(lastChar==" "){
			flag = flag.substr(0, flag.length-1);		// chop off last character
			lastChar = flag.charAt( flag.length-1 );
		}// while:  space exists at the end
		
		
		// catch:  !myFlag
		if( flag.charAt(0) == "!" ){
			flag = flag.substr(1)+"!";
			var endAt = flag.indexOf("!");
			var startAt = endAt+1;
		}// if:  flag starts with !
		else if( flag.indexOf("!=") != -1 ){
			var endAt = flag.indexOf("!=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<=") != -1 ){
			var endAt = flag.indexOf("<=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf(">=") != -1 ){
			var endAt = flag.indexOf(">=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<") != -1 ){
			var endAt = flag.indexOf("<");
			var startAt = endAt+1;
		}
		else if( flag.indexOf(">") != -1 ){
			var endAt = flag.indexOf(">");
			var startAt = endAt+1;
		}
		else if( flag.indexOf("=") != -1 ){
			var endAt = flag.indexOf("=");
			var startAt = endAt+1;
		}
		else{// if:  there's no operator
			var endAt = flag.length;
			flag = flag+"!=undefined"
			var startAt = endAt+2;
		}// if:  there's no operator
		
		parts_array.push(flag.substr( 0, endAt ));					// [0]	myFlag
		parts_array.push(flag.substring( endAt, startAt ));	// [1]	!=
		parts_array.push(flag.substr( startAt ));						// [2]	"merf"
		
		// remove space from end of flag name
		var lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		while(lastChar==" "){
			parts_array[0] = parts_array[0].substr(0, parts_array[0].length-1);		// chop off last character
			lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		}// while:  space exists at the end
		// remove space from beginning of value
		var firstChar = parts_array[2].charAt(0);
		while(firstChar==" "){
			parts_array[2] = parts_array[2].substr(1);		// chop off first character
			firstChar = parts_array[2].charAt(0);
		}// while:  space exists at the beginning
		
		return parts_array;
	}// getFlagParts()
	
	
	
	var addFlag = function( displayFlag, display_obj )
	{
		var show = true;
		
		// catch ""
		if(displayFlag == "")
			show = false;
		
		var flagParts_array = getFlagParts( displayFlag );
		var variable = flagParts_array[0];
		var operation = flagParts_array[1];
		var value = flagParts_array[2];
		
		// myFlag = undefined
		if(operation=="="  &&  value=="undefined")
			show = false;
		
		// _____________________________________________
		if(show)
		{// if:  show
			// create child objects  (if any)
			var object_array = variable.split(".");
			var dest_obj = display_obj;
			for( var ob=0; ob<object_array.length-1; ob++)
			{// for:  all objects before the variable
				var thisObject = object_array[ob];
				if(dest_obj[thisObject] == undefined)		// creates the object if it doesn't already exist
					dest_obj[thisObject] = {};
				dest_obj = dest_obj[thisObject];
			}// for:  all objects before the variable
			var variable = object_array[ object_array.length-1 ];		// chop off the object path, leaving only the variable name
			
			// convert value into likely datatype
			// // number
			if( isNaN(value)==false )
				value = Number(value);
			// // boolean
			if( value=="true" )
				value = true;
			if( value=="false" )
				value = false;
			// // string
			// already a string by default
			
			// create values
			switch( operation )
			{
				case "!":
					var decidedValue = undefined;
				break;
				case "=":
					var decidedValue = value;
				break;
				case "!=":
					if(value == "undefined"){
						var decidedValue = true;
					}else{
						var decidedValue = undefined;
					}
				break;
				case "<":
					var decidedValue = -Infinity;
				break;
				case ">":
					var decidedValue = Infinity;
				break;
				case "<=":
					var decidedValue = value;
				break;
				case ">=":
					var decidedValue = value;
				break;
			}// case:  operation
			dest_obj[variable] = decidedValue;
		}// if:  show
	}// addFlag()
	
	
	
	var checkFlag = function( spriteFlag, display_obj )
	{
		var output = true;			// returns boolean "false" when a flag fails a test
		var flagParts_array = getFlagParts( spriteFlag );
		var variable = flagParts_array[0];
		var operation = flagParts_array[1];
		var value = flagParts_array[2];
		
		// convert value into likely datatype
		// // number
		if( isNaN(value)==false )
			value = Number(value);
		// // boolean
		if( value=="true" )
			value = true;
		if( value=="false" )
			value = false;
		// // undefined
		if( value=="undefined" )
			value = undefined;
		// // string
		// already a string by default
		
		// separate variable name from variable path
		var endAt = variable.lastIndexOf(".");
		if( endAt != -1 )
		{// if:  there is an object path
			var flagPath = variable.substr(0, endAt);			// myObj.anotherObject
			var flagName = variable.substr( endAt+1 );		// myVar
			var flagPath = "display_obj."+flagPath;				// display_obj.myObj.anotherObject
		}// if:  there is an object path
		else
		{// if:  there are no preceeding objects
			var flagName = variable;
			var flagPath = "display_obj";
		}// if:  there are no preceeding objects
		var displayValue = eval(flagPath+"."+flagName);
		
		// check specified contents, in the specified ways
		switch( operation )
		{
			case "!":
				output = ( displayValue == undefined  ||  displayValue == false );		// these values return as true
			break;
			case "=":
				output = ( displayValue == value );
			break;
			case "!=":
				output = ( displayValue != value );
			break;
			case "<":
				output = ( displayValue < value );
			break;
			case ">":
				output = ( displayValue > value );
			break;
			case "<=":
				output = ( displayValue <= value );
			break;
			case ">=":
				output = ( displayValue >= value );
			break;
		}// case:  operation
		
		
		return output;
	}// checkFlag()
	// _______________________________________________________________________________
	
	
	
	
	
	var output_array = [];
	
	
	
	// apply display flags
	var display_obj = {};
//	outerDisplayObj = display_obj;
	for( var df=0; df<displayFlags.length; df++ )
	{// for:  each display flag
		var thisDisplayFlag = displayFlags[df];
		addFlag( thisDisplayFlag, display_obj );
	}// for:  each display flag
	
	
	
	// check sprites
	for( var s=0; s<sprites.length; s++)
	{// for:  each sprite
		var thisSprite = sprites[s];
		if(displayFlags.length > 0)
		{// if:  there are display conditions
			var testResult = true;
			for( var sf=0; sf<thisSprite.flags.length; sf++ )
			{// for:  each of this sprite's flags
				var thisSpriteFlag = thisSprite.flags[sf];
				var testResult = checkFlag( thisSpriteFlag, display_obj );
				if(testResult==false)
					break;		// flag failed, need to check any more
			}// for:  each of this sprite's flags
		}// if:  there are display conditions
		else
		{// if:  there are NO display restrictions
			var testResult = true;		// show all sprites
		}// if:  there are NO display restrictions
		
		if(testResult)												// if:  this sprite passed all the filters
			output_array.push( thisSprite );		// include it
	}// for:  each sprite
	
	
	// _______________________________________________________________________________
	return output_array;
}// getFlaggedSprites()